# Pomodoro Desktop (Electron)

Une application de bureau **installable** pour Windows, macOS et Linux basée sur Electron.
Le minuteur fonctionne **hors navigateur** et se lance comme une app classique.

## Prérequis
- Node.js 18+ et npm

## Installation pour construire l'installeur
```bash
npm install
npm run make
```
Les installeurs apparaîtront dans le dossier `out/make/` :
- **Windows** : `.exe` (Squirrel)
- **macOS** : `.zip` (prêt à ouvrir) — vous pouvez signer/notariser si nécessaire
- **Linux** : `.deb` et `.rpm`

> Pour lancer directement en mode développement : `npm start`

## Distribution à l'utilisateur final
1. Envoyez-lui le fichier installeur correspondant à son OS (ex: `.exe` Windows).
2. Il double-clique, installe, puis ouvre **Pomodoro Desktop** depuis le menu Démarrer / Applications.
3. Le timer fonctionne immédiatement (raccourcis : Espace, R, S). Les réglages sont sauvegardés.

## Personnalisation
- Icône : remplacez les PNG dans `assets/icons/` (Electron Forge les utilise automatiquement).
- Couleurs : modifiez `--brand` et autres variables CSS dans `src/index.html`.
- Lien « En savoir plus » (menu Aide) pointe vers l'article DSB Net.

## Signature (optionnel, production)
- **Windows** : certificat code signing (.pfx) + options du maker Squirrel.
- **macOS** : signature + notarisation (Apple Developer).
